{{-- resources/views/peninjauan/partials/edit-tab-pengukuran.blade.php --}}
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<style>
/* Additional styles for better UX */
.custom-div-icon {
    background: transparent;
    border: none;
}

.leaflet-popup-content {
    margin: 8px 12px;
    line-height: 1.4;
}

.leaflet-popup-content-wrapper {
    border-radius: 8px;
}

input[type="text"].form-control-sm:focus {
    border-color: #28a745;
    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
}

input[type="text"].form-control-sm.error {
    border-color: #dc3545;
}

.btn-sm {
    transition: all 0.3s ease;
}

.btn-sm:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.table-hover tbody tr:hover {
    background-color: rgba(40, 167, 69, 0.05);
}

/* Loading animation */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.fa-spinner.fa-spin {
    animation: spin 1s linear infinite;
}

/* Smooth transitions */
.card {
    transition: box-shadow 0.3s ease;
}

.card:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

/* Responsive map container */
#pengukuranMap {
    position: relative;
    min-height: 450px;
}

@media (max-width: 768px) {
    #pengukuranMap {
        height: 350px !important;
    }

    .rtrw-legend-item {
        font-size: 12px;
    }
}

/* RTRW Legend hover effect */
.rtrw-legend-item {
    cursor: pointer;
    transition: all 0.3s ease;
}

.rtrw-legend-item:active {
    transform: scale(0.98);
}

/* Progress bar animation */
.progress-bar {
    transition: width 0.6s ease;
}

/* Better tooltips */
[title] {
    position: relative;
}

/* SweetAlert2 custom styling */
.swal2-popup {
    font-family: 'Arial', sans-serif;
}

.swal2-title {
    font-size: 1.5rem;
}

/* Leaflet control custom styling */
.leaflet-control {
    box-shadow: 0 2px 6px rgba(0,0,0,0.3);
}

.leaflet-control button:hover {
    background-color: #f8f9fa !important;
}
</style>
<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
}

.rtrw-legend-item {
    display: flex;
    align-items: center;
    padding: 8px 12px;
    margin: 5px;
    border-radius: 6px;
    background: white;
    border: 2px solid #e3e6f0;
    transition: all 0.3s ease;
}

.rtrw-legend-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    border-color: #4e73df;
}



.rtrw-legend-name {
    font-weight: 500;
    font-size: 13px;
    flex: 1;
}

.rtrw-legend-code {
    font-size: 11px;
    color: #6c757d;
    background: #f8f9fa;
    padding: 2px 8px;
    border-radius: 10px;
}
</style>
<!-- Pengukuran Tab -->
<div class="tab-pane fade" id="pengukuran" role="tabpanel">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Pengukuran, Persetujuan, Koordinat</h5>
        </div>
        <div class="card-body">
            <!-- BA Pengukuran Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <h6 class="text-primary border-bottom pb-2 mb-3">BA Pengukuran Bidang Tanah</h6>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nomor_ba_pengukuran" class="form-label">Nomor BA Pengukuran</label>
                        <input type="text" class="form-control" id="nomor_ba_pengukuran" name="nomor_ba_pengukuran"
                               value="{{ old('nomor_ba_pengukuran', $peninjauan->nomor_ba_pengukuran) }}" placeholder="Masukkan nomor BA">
                        @error('nomor_ba_pengukuran')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tanggal_pengukuran" class="form-label">Tanggal Pengukuran</label>
               <input type="date" class="form-control" id="tanggal_pengukuran" name="tanggal_pengukuran"
                   value="{{ old('tanggal_pengukuran', ($peninjauan->tanggal_pengukuran ? (is_a($peninjauan->tanggal_pengukuran, 'Carbon\Carbon') ? $peninjauan->tanggal_pengukuran->format('Y-m-d') : (strlen($peninjauan->tanggal_pengukuran) >= 10 ? substr($peninjauan->tanggal_pengukuran,0,10) : $peninjauan->tanggal_pengukuran)) : '')) }}">
                        @error('tanggal_pengukuran')
                            <div class="text-danger small mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Keterangan Pengukuran -->
            <div class="row mb-4">
                <div class="col-12">
                    <h6 class="text-primary border-bottom pb-2 mb-3">Keterangan Pengukuran</h6>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="surat_tugas_nomor" class="form-label">Nomor Surat Tugas</label>
                        <input type="text" class="form-control" id="surat_tugas_nomor" name="surat_tugas_nomor"
                               value="{{ old('surat_tugas_nomor', $peninjauan->surat_tugas_nomor) }}" placeholder="Nomor surat tugas">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="surat_tugas_tanggal" class="form-label">Tanggal Surat</label>
               <input type="date" class="form-control" id="surat_tugas_tanggal" name="surat_tugas_tanggal"
                   value="{{ old('surat_tugas_tanggal', ($peninjauan->surat_tugas_tanggal ? (is_a($peninjauan->surat_tugas_tanggal, 'Carbon\Carbon') ? $peninjauan->surat_tugas_tanggal->format('Y-m-d') : (strlen($peninjauan->surat_tugas_tanggal) >= 10 ? substr($peninjauan->surat_tugas_tanggal,0,10) : $peninjauan->surat_tugas_tanggal)) : '')) }}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas_ukur" class="form-label">Petugas Ukur</label>
                        <input type="text" class="form-control" id="petugas_ukur" name="petugas_ukur"
                               value="{{ old('petugas_ukur', $peninjauan->petugas_ukur) }}" placeholder="Nama petugas">
                    </div>
                </div>
            </div>
            <hr>
             <div class="row mb-4">
                <div class="col-12">
                    <h6 class="text-primary border-bottom pb-2 mb-3">BA Persetujuan Pengukuran Tanah</h6>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="no_ba_persetujuan_pengukuran_tanah" class="form-label">Nomor Surat Tugas</label>
                        <input type="text" class="form-control" id="no_ba_persetujuan_pengukuran_tanah" name="no_ba_persetujuan_pengukuran_tanah"
                               value="{{ old('no_ba_persetujuan_pengukuran_tanah', $peninjauan->no_ba_persetujuan_pengukuran_tanah) }}" placeholder="Nomor surat tugas">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="tanggal_permohonan_pengukuran" class="form-label">Tanggal Permohonan</label>
                        <input type="date" class="form-control" id="tanggal_permohonan_pengukuran" name="tanggal_permohonan_pengukuran"
                               value="{{ old('tanggal_permohonan_pengukuran', $peninjauan->tanggal_permohonan_pengukuran) }}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="ukuran_patok" class="form-label">Ukuran Patok (cm)</label>
                        <input type="number" class="form-control" id="ukuran_patok" name="ukuran_patok"
                               value="{{ old('ukuran_patok', $peninjauan->ukuran_patok) }}" placeholder="Ukuran" step="0.01">
                    </div>
                </div>
            </div>
            <!-- Sistem Koordinat -->
            <div class="row mb-4">
                <div class="col-12">
                    <h6 class="text-primary border-bottom pb-2 mb-3">Sistem Koordinat</h6>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label class="form-label">Sistem Koordinat</label>
                        <input type="text" class="form-control bg-light" name="sistem_koordinat"
                               value="{{ old('sistem_koordinat', $peninjauan->sistem_koordinat ?? 'UTM') }}" readonly>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="cm_x" class="form-label">CM X</label>
                        <input type="text" class="form-control" id="cm_x" name="cm_x"
                               value="{{ old('cm_x', $peninjauan->cm_x) }}" placeholder="X">
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="tanggal_pengukuran_koordinat" class="form-label">Tanggal Pengukuran</label>
               <input type="date" class="form-control" id="tanggal_pengukuran_koordinat"
                   name="tanggal_pengukuran_koordinat" value="{{ old('tanggal_pengukuran_koordinat', ($peninjauan->tanggal_pengukuran_koordinat ? (is_a($peninjauan->tanggal_pengukuran_koordinat, 'Carbon\Carbon') ? $peninjauan->tanggal_pengukuran_koordinat->format('Y-m-d') : (strlen($peninjauan->tanggal_pengukuran_koordinat) >= 10 ? substr($peninjauan->tanggal_pengukuran_koordinat,0,10) : $peninjauan->tanggal_pengukuran_koordinat)) : '')) }}">
                    </div>
                </div>
            </div>

            <!-- Map and Coordinates Section -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card border-primary">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0">Data Koordinat</h6>
                        </div>
                        <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th width="15%">No</th>
                                        <th width="35%">Easting (m)</th>
                                        <th width="35%">Northing (m)</th>
                                        <th width="15%" class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody id="coordinatesList">
                                    @if(isset($utmCoordinates) && count($utmCoordinates) > 0)
                                        @foreach($utmCoordinates as $i => $utm)
                                            <tr id="coord-{{ $i+1 }}">
                                                <td class="align-middle font-weight-bold">{{ $i+1 }}</td>
                                                <td>
                                                    <input type="text" name="easting[]" id="easting_{{ $i+1 }}" value="{{ $utm->easting }}" class="form-control form-control-sm" />
                                                </td>
                                                <td>
                                                    <input type="text" name="northing[]" id="northing_{{ $i+1 }}" value="{{ $utm->northing }}" class="form-control form-control-sm" />
                                                </td>
                                                <td class="text-center">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeCoordinate({{ $i+1 }})">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            <button type="button" onclick="addCoordinate()" class="btn btn-primary btn-sm btn-block">
                                + Tambah Koordinat
                            </button>
                        </div>
                    </div>

                    <!-- Area Information -->
                    <div class="card border-success mt-3">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0">Informasi Area</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <div class="text-center">
                                        <div class="h4 text-success mb-1" id="calculatedArea">
                                            {{ number_format($peninjauan->luas_terukur_otomatis ?? 0, 2, ',', '.') }} m²
                                        </div>
                                        <small class="text-muted">Luas Terukur Otomatis</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center">
                                        <div class="h4 text-info mb-1" id="coordinateCount">0</div>
                                        <small class="text-muted">Titik Koordinat</small>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-2">
                                <div class="progress" style="height: 6px;">
                                    <div class="progress-bar bg-success" id="areaProgress" style="width: 0%"></div>
                                </div>
                                <small class="text-muted">Status: <span id="areaStatus">Menghitung...</span></small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="card border-info">
                        <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Peta Lokasi</h6>
                            <div class="btn-group btn-group-sm">
                                <button type="button" onclick="centerMap()" class="btn btn-light btn-sm" title="Pusatkan peta">
                                    📍 Center
                                </button>
                                <button type="button" onclick="captureMap()" class="btn btn-warning btn-sm" title="Capture peta">
                                    📷 Capture
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div id="pengukuranMap" style="height: 450px; border-radius: 0 0 6px 6px;"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mt-3">
                <div class="card border-primary">
                    <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
                        <h6 class="mb-0 text-white">
                            <i class="fas fa-layer-group"></i> Informasi Wilayah RTRW
                        </h6>
                        <div class="btn-group btn-group-sm">
                            <button type="button" onclick="loadRTRWData()" class="btn btn-light btn-sm" title="Refresh data RTRW">
                                <i class="fas fa-sync-alt"></i> Refresh
                            </button>
                            <button type="button" onclick="checkAllCoordinatesRTRW()" class="btn btn-warning btn-sm" title="Analisis semua koordinat">
                                <i class="fas fa-search-location"></i> Cek RTRW
                            </button>
                            <button type="button" onclick="toggleRTRWOverlay()" class="btn btn-info btn-sm" title="Toggle tampilan RTRW di peta">
                                <i class="fas fa-eye"></i> Toggle
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="alert alert-info mb-3">
                                    <h6 class="alert-heading">
                                        <i class="fas fa-info-circle"></i> Fitur Pengecekan RTRW
                                    </h6>
                                    <hr>
                                    <ul class="small mb-0 pl-3">
                                        <li>Sistem akan otomatis mengecek setiap koordinat yang diinput</li>
                                        <li>Wilayah RTRW ditampilkan sebagai overlay di peta</li>
                                        <li>Klik tombol "Analisis" untuk melihat ringkasan lengkap</li>
                                        <li>Klik pada peta akan menampilkan informasi wilayah</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div id="rtrwSummary" class="border rounded p-3 bg-light">
                                    <div class="text-center text-muted py-3">
                                        <i class="fas fa-spinner fa-spin fa-2x mb-2"></i>
                                        <p class="mb-0 small">Memuat data RTRW...</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- RTRW Legend -->
                        <div class="mt-3">
                            <h6 class="font-weight-bold mb-3">
                                <i class="fas fa-palette"></i> Legend Wilayah RTRW:
                            </h6>
                            <div id="rtrwLegend" class="row">
                                <!-- Will be populated by JavaScript -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>

            <!-- Hidden inputs for form submission -->
            <input type="hidden" name="luas_terukur_otomatis" id="luas_terukur_otomatis"
                   value="{{ old('luas_terukur_otomatis', $peninjauan->luas_terukur_otomatis) }}">
            <!-- Script untuk memastikan input hidden selalu sinkron dengan calculatedArea -->
            <script>
            function syncCalculatedAreaToHidden() {
                var areaInput = document.getElementById('luas_terukur_otomatis');
                var areaDisplay = document.getElementById('calculatedArea');
                if (areaInput && areaDisplay) {
                    // Ambil angka dari display, hilangkan ' m²'
                    var areaValue = areaDisplay.textContent.replace(/[^\d.,]/g, '').replace(',', '.');
                    areaInput.value = areaValue;
                }
            }
            document.addEventListener('DOMContentLoaded', function() {
                setInterval(syncCalculatedAreaToHidden, 500);
            });
            </script>
            <input type="hidden" name="map_image_data" id="map_image_data"
                   value="{{ old('map_image_data', $peninjauan->map_image_data) }}">
            <input type="hidden" name="polygon_bounds" id="polygon_bounds"
                   value="{{ old('polygon_bounds', $peninjauan->polygon_bounds) }}">
            <input type="hidden" name="coordinates_data" id="coordinates_input"
                   value="{{ old('coordinates_data', $peninjauan->coordinates_data) }}">
        </div>

        <!-- Form Actions -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">

                <div class="text-center">
                    <small class="text-muted">Status: <span id="saveStatus" class="text-info">Siap untuk disimpan</span></small>
                </div>

            </div>
        </div>
    </div>
</div>

@push('scripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/proj4js/2.7.4/proj4.js"></script>

<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@turf/turf@6.5.0/turf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// ============================================
// UTM COORDINATE CONVERSION SETUP
// ============================================

// Define UTM Zone 50S (for Kalimantan Timur - Berau area)
// You can adjust the zone based on your specific location
proj4.defs("EPSG:32750", "+proj=utm +zone=50 +south +datum=WGS84 +units=m +no_defs");

// Helper function to convert UTM to Lat/Lng
function utmToLatLng(easting, northing, zone = 50, isSouth = true) {
    const utmProj = isSouth ? `+proj=utm +zone=${zone} +south +datum=WGS84 +units=m +no_defs` : `+proj=utm +zone=${zone} +datum=WGS84 +units=m +no_defs`;
    const wgs84 = "+proj=longlat +datum=WGS84 +no_defs";

    try {
        const [lng, lat] = proj4(utmProj, wgs84, [parseFloat(easting), parseFloat(northing)]);
        return { lat: lat, lng: lng };
    } catch (error) {
        console.error('Error converting UTM to Lat/Lng:', error);
        return null;
    }
}

// Helper function to convert Lat/Lng to UTM
function latLngToUTM(lat, lng, zone = 50, isSouth = true) {
    const utmProj = isSouth ? `+proj=utm +zone=${zone} +south +datum=WGS84 +units=m +no_defs` : `+proj=utm +zone=${zone} +datum=WGS84 +units=m +no_defs`;
    const wgs84 = "+proj=longlat +datum=WGS84 +no_defs";

    try {
        const [easting, northing] = proj4(wgs84, utmProj, [parseFloat(lng), parseFloat(lat)]);
        return { easting: easting, northing: northing };
    } catch (error) {
        console.error('Error converting Lat/Lng to UTM:', error);
        return null;
    }
}

// ============================================
// PART 2: GLOBAL VARIABLES & INITIALIZATION
// ============================================

// Global variables for map and coordinates
let pengukuranMap = null;
let pengukuranPolygon = null;
let pengukuranMarkers = [];
let coordinateCount = 0;
let coordinates = []; // Will store as {lat, lng} for Leaflet
let coordinatesUTM = []; // Will store as {easting, northing} for display
let calculatedArea = 0;
let mapInitialized = false;

// Global variables for RTRW
let rtrwData = [];
let rtrwLayers = [];
let rtrwOverlayVisible = true;
let isCheckingRTRW = false;

// Load existing coordinates from database
let existingCoordinates = [];

// Prioritas 1: Gunakan data UTM jika ada
@if(isset($utmCoordinates) && count($utmCoordinates) > 0)
    existingCoordinates = @json(collect($utmCoordinates)->map(function($utm) {
        // Konversi UTM ke Lat/Lng untuk map
        $lat = null;
        $lng = null;
        // Di sini kita simpan UTM, nanti akan dikonversi di JavaScript
        return [
            'easting' => (float)$utm->easting,
            'northing' => (float)$utm->northing
        ];
    })->values());

    // Konversi UTM ke Lat/Lng di JavaScript
    existingCoordinates = existingCoordinates.map(coord => {
        const latLng = utmToLatLng(coord.easting, coord.northing);
        return {
            lat: latLng ? latLng.lat : null,
            lng: latLng ? latLng.lng : null,
            easting: coord.easting.toFixed(2),
            northing: coord.northing.toFixed(2)
        };
    }).filter(coord => coord.lat !== null && coord.lng !== null);

    console.log('Loaded UTM coordinates from utm_coordinates table:', existingCoordinates.length, 'points');

// Prioritas 2: Gunakan data dari coordinates table jika tidak ada UTM
@elseif(isset($peninjauan) && $peninjauan->coordinates && $peninjauan->coordinates->count() > 0)
    existingCoordinates = @json($peninjauan->coordinates->map(function($coord) {
        return ['lat' => (float)$coord->latitude, 'lng' => (float)$coord->longitude];
    })->values());

    // Convert existing Lat/Lng coordinates to UTM for display
    if (existingCoordinates && Array.isArray(existingCoordinates)) {
        existingCoordinates = existingCoordinates.filter(coord =>
            coord && typeof coord.lat === 'number' && typeof coord.lng === 'number'
        ).map(coord => {
            // Convert to UTM for storage and display
            const utmCoord = latLngToUTM(coord.lat, coord.lng);
            return {
                lat: coord.lat,
                lng: coord.lng,
                easting: utmCoord ? utmCoord.easting.toFixed(2) : '',
                northing: utmCoord ? utmCoord.northing.toFixed(2) : ''
            };
        });
    }

    console.log('Loaded Lat/Lng coordinates from coordinates table:', existingCoordinates.length, 'points');

// Prioritas 3: Gunakan coordinates_data JSON jika ada
@elseif(isset($peninjauan) && $peninjauan->coordinates_data)
    try {
        const coordData = @json($peninjauan->coordinates_data);
        existingCoordinates = typeof coordData === 'string' ? JSON.parse(coordData) : (coordData || []);

        // Convert to UTM
        existingCoordinates = existingCoordinates.map(coord => {
            const utmCoord = latLngToUTM(coord.lat, coord.lng);
            return {
                lat: coord.lat,
                lng: coord.lng,
                easting: utmCoord ? utmCoord.easting.toFixed(2) : '',
                northing: utmCoord ? utmCoord.northing.toFixed(2) : ''
            };
        });

        console.log('Loaded coordinates from coordinates_data JSON:', existingCoordinates.length, 'points');
    } catch(e) {
        console.error('Error parsing coordinates_data:', e);
        existingCoordinates = [];
    }
@else
    existingCoordinates = [];
    console.log('No existing coordinates found');
@endif

console.log('Final loaded coordinates:', existingCoordinates.length, 'points');
</script>
<script>
// ============================================
// PART 3: VALIDATION FUNCTIONS
// ============================================

// Coordinate validation function for UTM
function isValidUTMCoordinate(easting, northing) {
    return (
        typeof easting === 'number' &&
        typeof northing === 'number' &&
        !isNaN(easting) &&
        !isNaN(northing) &&
        easting >= 166000 && // Approximate valid range for Zone 50S in Kalimantan
        easting <= 834000 &&
        northing >= 9000000 && // Southern hemisphere
        northing <= 10000000
    );
}

// Original lat/lng validation (still needed for map operations)
function isValidCoordinate(lat, lng) {
    return (
        typeof lat === 'number' &&
        typeof lng === 'number' &&
        !isNaN(lat) &&
        !isNaN(lng) &&
        lat >= -90 &&
        lat <= 90 &&
        lng >= -180 &&
        lng <= 180
    );
}

// Show error message in map container
function showMapError(message) {
    const mapContainer = document.getElementById('pengukuranMap');
    if (mapContainer) {
        mapContainer.innerHTML = `
            <div style="display: flex; align-items: center; justify-content: center; height: 450px; background: #f8f9fa; border: 2px dashed #dee2e6; flex-direction: column;">
                <div style="color: #6c757d; font-size: 16px; margin-bottom: 10px;">⚠️ ${message}</div>
                <button onclick="initPengukuranMap()" class="btn btn-primary btn-sm">
                    <i class="fas fa-redo"></i> Coba Lagi
                </button>
            </div>
        `;
    }
}

// Validate coordinate input on blur
function validateCoordinateInput(input) {
    if (!input || !input.value) return;

    const value = parseFloat(input.value);
    const isEasting = input.name.includes('easting');

    if (isNaN(value)) {
        input.style.borderColor = '#dc3545';
        input.title = 'Harus berupa angka';
        return false;
    }

    if (isEasting && (value < 166000 || value > 834000)) {
        input.style.borderColor = '#dc3545';
        input.title = 'Easting harus antara 166000 dan 834000 meter (UTM Zone 50S)';
        return false;
    }

    if (!isEasting && (value < 9000000 || value > 10000000)) {
        input.style.borderColor = '#dc3545';
        input.title = 'Northing harus antara 9000000 dan 10000000 meter (UTM Zone 50S)';
        return false;
    }

    input.style.borderColor = '#28a745';
    input.title = '';
    return true;
}

// Update coordinate from UTM input change
function updateFromUTM(index) {
    const eastingInput = document.getElementById(`easting_${index}`);
    const northingInput = document.getElementById(`northing_${index}`);

    if (!eastingInput || !northingInput) {
        console.warn('UTM inputs not found for index:', index);
        return;
    }

    const easting = parseFloat(eastingInput.value);
    const northing = parseFloat(northingInput.value);

    if (isNaN(easting) || isNaN(northing)) {
        console.warn('Invalid UTM values');
        return;
    }

    // Validate UTM coordinates
    if (!validateCoordinateInput(eastingInput) || !validateCoordinateInput(northingInput)) {
        console.warn('UTM validation failed');
        return;
    }

    // Convert UTM to Lat/Lng
    const latLng = utmToLatLng(easting, northing);

    if (!latLng) {
        console.error('Failed to convert UTM to Lat/Lng');
        return;
    }

    console.log(`UTM (${easting}, ${northing}) → Lat/Lng (${latLng.lat}, ${latLng.lng})`);

    // Update the coordinates array (Leaflet needs Lat/Lng)
    const coordIndex = coordinates.findIndex((c, i) => {
        const row = document.getElementById(`coord-${index}`);
        return row && Array.from(document.querySelectorAll('#coordinatesList tr')).indexOf(row) === i;
    });

    if (coordIndex >= 0) {
        coordinates[coordIndex] = latLng;
    }

    // Update map and calculations
    updateMapAndCalculate();
}
</script>
<script>
// ============================================
// PART 4: LOAD EXISTING COORDINATES
// ============================================

// Load existing coordinates into table
function loadExistingCoordinates() {
    const tbody = document.getElementById('coordinatesList');
    if (!tbody) {
        console.error('coordinatesList element not found');
        return;
    }

    tbody.innerHTML = '';
    coordinateCount = 0;
    coordinates = [];
    coordinatesUTM = [];

    // Use existing coordinates or create default ones (as Lat/Lng, will convert to UTM)
    const coordsToLoad = (existingCoordinates && existingCoordinates.length > 0)
        ? existingCoordinates
        : [
            {lat: -1.2417, lng: 116.8730},
            {lat: -1.2418, lng: 116.8729},
            {lat: -1.2419, lng: 116.8731}
        ].map(coord => {
            const utm = latLngToUTM(coord.lat, coord.lng);
            return {
                lat: coord.lat,
                lng: coord.lng,
                easting: utm ? utm.easting.toFixed(2) : '',
                northing: utm ? utm.northing.toFixed(2) : ''
            };
        });

    coordsToLoad.forEach((coord, index) => {
        // Validate using lat/lng if available, otherwise convert from UTM
        let lat = coord.lat;
        let lng = coord.lng;
        let easting = coord.easting || '';
        let northing = coord.northing || '';

        // If we don't have lat/lng but have UTM, convert
        if ((!lat || !lng) && easting && northing) {
            const latLng = utmToLatLng(easting, northing);
            if (latLng) {
                lat = latLng.lat;
                lng = latLng.lng;
            }
        }

        // If we don't have UTM but have lat/lng, convert
        if ((!easting || !northing) && lat && lng) {
            const utm = latLngToUTM(lat, lng);
            if (utm) {
                easting = utm.easting.toFixed(2);
                northing = utm.northing.toFixed(2);
            }
        }

        if (!isValidCoordinate(lat, lng)) {
            console.warn('Invalid coordinate at index', index, ':', coord);
            return;
        }

        coordinateCount++;
        coordinates.push({lat: lat, lng: lng});
        coordinatesUTM.push({easting: parseFloat(easting), northing: parseFloat(northing)});

        const row = document.createElement('tr');
        row.id = `coord-${coordinateCount}`;
        row.innerHTML = `
            <td class="align-middle font-weight-bold">${index + 1}</td>
            <td>
                <input type="text"
                       class="form-control form-control-sm"
                       id="easting_${coordinateCount}"
                       name="easting[${coordinateCount}]"
                       value="${easting}"
                       onchange="updateFromUTM(${coordinateCount})"
                       onblur="validateCoordinateInput(this)"
                       placeholder="Easting (m)">
            </td>
            <td>
                <input type="text"
                       class="form-control form-control-sm"
                       id="northing_${coordinateCount}"
                       name="northing[${coordinateCount}]"
                       value="${northing}"
                       onchange="updateFromUTM(${coordinateCount})"
                       onblur="validateCoordinateInput(this)"
                       placeholder="Northing (m)">
            </td>
            <td class="text-center">
                <button type="button" onclick="removeCoordinate(${coordinateCount})"
                        class="btn btn-danger btn-sm" title="Hapus koordinat">
                    <i class="fas fa-trash"></i>
                </button>
            </td>
        `;

        tbody.appendChild(row);
    });

    console.log('Loaded coordinates:', coordinateCount, 'points (UTM format)');
}
</script>
<script>
// ============================================
// PART 5: MAP INITIALIZATION
// ============================================

// Enhanced map initialization with error handling
function initPengukuranMap() {
    if (mapInitialized && pengukuranMap) {
        console.log('Map already initialized, updating...');
        updateMapAndCalculate();
        return;
    }

    try {
        // Clear any existing map instance
        if (pengukuranMap) {
            pengukuranMap.remove();
            pengukuranMap = null;
        }

        // Check internet connection
        if (!navigator.onLine) {
            showMapError('Tidak ada koneksi internet');
            return;
        }

        // Initialize map with bounds checking
        const center = coordinates.length > 0
            ? [coordinates[0].lat, coordinates[0].lng]
            : [-1.2417, 116.8730];
        const zoom = 18;

        // Validate coordinates before initialization
        if (!isValidCoordinate(center[0], center[1])) {
            throw new Error('Invalid center coordinates');
        }

        pengukuranMap = L.map('pengukuranMap', {
            center: center,
            zoom: zoom,
            maxZoom: 20,
            minZoom: 1,
            zoomControl: true,
            attributionControl: true,
            preferCanvas: false
        });

        // Primary tile layer with error handling
        const osmLayer = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors',
            maxZoom: 20,
            minZoom: 1,
            errorTileUrl: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg==',
            tileSize: 256,
            subdomains: ['a', 'b', 'c']
        });

        // Alternative tile layers as fallbacks
        const cartoDB = L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png', {
            attribution: '© CARTO © OpenStreetMap contributors',
            maxZoom: 20,
            minZoom: 1,
            subdomains: 'abcd'
        });

        // Handle tile errors and auto-fallback
        let tileErrorCount = 0;
        osmLayer.on('tileerror', function(error) {
            tileErrorCount++;
            console.warn('OSM tile error:', tileErrorCount);

            if (tileErrorCount >= 3 && !pengukuranMap.hasLayer(cartoDB)) {
                console.log('Switching to CartoDB due to tile errors');
                pengukuranMap.removeLayer(osmLayer);
                cartoDB.addTo(pengukuranMap);
            }
        });

        // Add primary layer
        osmLayer.addTo(pengukuranMap);

        // Layer control
        const baseLayers = {
            "OpenStreetMap": osmLayer,
            "CartoDB Light": cartoDB
        };

        L.control.layers(baseLayers).addTo(pengukuranMap);

        // Add scale control
        L.control.scale({
            position: 'bottomright',
            metric: true,
            imperial: false
        }).addTo(pengukuranMap);

        // Map click event handler
        // pengukuranMap.on('click', handleMapClick);

        // // Handle map errors
        // pengukuranMap.on('error', function(e) {
        //     console.error('Map error:', e);
        //     showMapError('Terjadi kesalahan pada peta. Silakan coba lagi.');
        // });

        mapInitialized = true;
        console.log('Map initialized successfully');

        // Load existing coordinates into table
        loadExistingCoordinates();

        // Initial update with delay
        setTimeout(function() {
            updateMapAndCalculate();

            // Load RTRW data after map is ready
            loadRTRWData().then(() => {
                console.log('RTRW data loaded');
                // addRTRWToggleButton();
            }).catch(err => {
                console.error('Failed to load RTRW data:', err);
            });
        }, 100);

    } catch (error) {
        console.error('Error initializing map:', error);
        showMapError('Gagal memuat peta. Silakan coba lagi atau periksa koneksi internet.');
        mapInitialized = false;
    }
}

// Map click handler
// function handleMapClick(e) {
//     const lat = e.latlng.lat;
//     const lng = e.latlng.lng;

//     if (!isValidCoordinate(lat, lng)) {
//         Swal.fire({
//             icon: 'error',
//             title: 'Koordinat Tidak Valid',
//             text: 'Koordinat yang diklik tidak valid!',
//             confirmButtonColor: '#dc3545'
//         });
//         return;
//     }

//     const latRounded = lat.toFixed(8);
//     const lngRounded = lng.toFixed(8);

//     // Check RTRW terlebih dahulu jika data sudah loaded
//     if (rtrwData.length > 0) {
//         const rtrwResults = checkPointInRTRW(parseFloat(latRounded), parseFloat(lngRounded));

//         let rtrwInfo = rtrwResults.length > 0
//             ? `<div style="text-align: left; margin-top: 10px;">
//                  <hr>
//                  <p><strong>Area RTRW:</strong></p>
//                  ${rtrwResults.map(r => `
//                     <div style="margin-left: 20px; margin-bottom: 5px;">
//                         <span style="display: inline-block; width: 15px; height: 15px; background: ${r.warna}; border: 1px solid #ccc; margin-right: 5px;"></span>
//                         ${r.nama_rtrw}
//                     </div>
//                  `).join('')}
//                </div>`
//             : `<div style="text-align: left; margin-top: 10px;">
//                  <hr>
//                  <p style="color: #856404;">
//                      <i class="fas fa-exclamation-triangle"></i>
//                      Tidak dalam area RTRW yang terdaftar
//                  </p>
//                </div>`;

//         Swal.fire({
//             icon: 'question',
//             title: 'Tambah Koordinat?',
//             html: `
//                 <div style="text-align: left;">
//                     <p><strong>Latitude:</strong> ${latRounded}</p>
//                     <p><strong>Longitude:</strong> ${lngRounded}</p>
//                     ${rtrwInfo}
//                 </div>
//             `,
//             showCancelButton: true,
//             confirmButtonColor: '#28a745',
//             cancelButtonColor: '#6c757d',
//             confirmButtonText: '<i class="fas fa-check"></i> Ya, Tambahkan',
//             cancelButtonText: '<i class="fas fa-times"></i> Batal',
//             width: '500px'
//         }).then((result) => {
//             if (result.isConfirmed) {
//                 addCoordinateWithValues(latRounded, lngRounded);
//             }
//         });
//     } else {
//         // Jika RTRW belum loaded, tampilkan dialog sederhana
//         if (confirm(`Tambah koordinat baru?\nLatitude: ${latRounded}\nLongitude: ${lngRounded}`)) {
//             addCoordinateWithValues(latRounded, lngRounded);
//         }
//     }
// }
</script>
<script>
// ============================================
// PART 6: UPDATE MAP AND CALCULATE AREA
// ============================================

// Enhanced coordinate validation and map update
function updateMapAndCalculate() {
    if (!pengukuranMap || !mapInitialized) {
        console.warn('Map not initialized, skipping update');
        return;
    }

    try {
        // Clear existing markers and polygon
        pengukuranMarkers.forEach(marker => {
            try {
                if (pengukuranMap.hasLayer(marker)) {
                    pengukuranMap.removeLayer(marker);
                }
            } catch (e) {
                console.warn('Error removing marker:', e);
            }
        });
        pengukuranMarkers = [];

        if (pengukuranPolygon && pengukuranMap.hasLayer(pengukuranPolygon)) {
            try {
                pengukuranMap.removeLayer(pengukuranPolygon);
            } catch (e) {
                console.warn('Error removing polygon:', e);
            }
        }

        // Get coordinates from UTM inputs with validation
        coordinates = [];
        coordinatesUTM = [];
        const rows = document.querySelectorAll('#coordinatesList tr');

        rows.forEach((row, index) => {
            const coordId = row.id ? row.id.split('-')[1] : (index + 1);
            const eastingInput = document.getElementById(`easting_${coordId}`);
            const northingInput = document.getElementById(`northing_${coordId}`);

            if (eastingInput && northingInput && eastingInput.value && northingInput.value) {
                const easting = parseFloat(eastingInput.value);
                const northing = parseFloat(northingInput.value);

                // Reset border colors
                eastingInput.style.borderColor = '';
                northingInput.style.borderColor = '';

                // Validate UTM coordinates
                if (isValidUTMCoordinate(easting, northing)) {
                    // Store UTM coordinates
                    coordinatesUTM.push({easting: easting, northing: northing});

                    // Convert to Lat/Lng for map display
                    const latLng = utmToLatLng(easting, northing);

                    if (latLng && isValidCoordinate(latLng.lat, latLng.lng)) {
                        coordinates.push(latLng);

                        // Add numbered marker
                        try {
                            const marker = L.marker([latLng.lat, latLng.lng], {
                                icon: L.divIcon({
                                    className: 'custom-div-icon',
                                    html: `<div style="background: #28a745; color: white; width: 28px; height: 28px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: bold; border: 2px solid white; box-shadow: 0 2px 6px rgba(0,0,0,0.3);">${index + 1}</div>`,
                                    iconSize: [28, 28],
                                    iconAnchor: [14, 14]
                                })
                            });

                            marker.addTo(pengukuranMap);
                            pengukuranMarkers.push(marker);

                            // Add popup with both UTM and Lat/Lng
                            marker.bindPopup(`
                                <strong>Titik ${index + 1}</strong><br>
                                <b>UTM Zone 50S:</b><br>
                                Easting: ${easting.toFixed(2)} m<br>
                                Northing: ${northing.toFixed(2)} m<br>
                                <hr style="margin: 5px 0;">
                                <b>Lat/Lng:</b><br>
                                Lat: ${latLng.lat.toFixed(8)}°<br>
                                Lng: ${latLng.lng.toFixed(8)}°
                            `);

                        } catch (markerError) {
                            console.error('Error adding marker:', markerError);
                        }
                    } else {
                        console.warn(`UTM conversion failed at index ${index}:`, easting, northing);
                        eastingInput.style.borderColor = '#dc3545';
                        northingInput.style.borderColor = '#dc3545';
                    }
                } else {
                    console.warn(`Invalid UTM coordinate at index ${index}:`, easting, northing);
                    eastingInput.style.borderColor = '#dc3545';
                    northingInput.style.borderColor = '#dc3545';
                }
            }
        });

        // Update coordinate count
        const countElement = document.getElementById('coordinateCount');
        if (countElement) {
            countElement.textContent = coordinates.length;
        }

        // Draw polygon if we have at least 3 valid coordinates
        if (coordinates.length >= 3) {
            try {
                const latlngs = coordinates.map(coord => [coord.lat, coord.lng]);
                pengukuranPolygon = L.polygon(latlngs, {
                    color: '#28a745',
                    fillColor: '#28a745',
                    fillOpacity: 0.3,
                    weight: 3,
                    dashArray: '5, 5'
                });

                pengukuranPolygon.addTo(pengukuranMap);

                // Calculate area
                calculatedArea = calculatePolygonArea();

                // Add polygon popup
                pengukuranPolygon.bindPopup(`
                    <strong>Area Polygon</strong><br>
                    Luas: ${calculatedArea.toLocaleString('id-ID', {maximumFractionDigits: 2})} m²<br>
                    Titik: ${coordinates.length}
                `);

                // Update UI
                updateAreaStatus(true);

                // Update hidden inputs
                updateHiddenInputs();

                // Fit map to polygon bounds
                const bounds = pengukuranPolygon.getBounds();
                if (bounds.isValid()) {
                    pengukuranMap.fitBounds(bounds, {padding: [50, 50]});
                }

                // Trigger auto-capture after polygon is drawn
                if (typeof autoCapture === 'function') {
                    autoCapture();
                }

            } catch (polygonError) {
                console.error('Error creating polygon:', polygonError);
                updateAreaStatus(false, 'Error membuat polygon');
            }
        } else {
            updateAreaStatus(false, 'Minimal 3 titik diperlukan');
            updateHiddenInputs();
        }

    } catch (error) {
        console.error('Error updating map:', error);
        updateAreaStatus(false, 'Error updating map');
    }
}

// Update area status function
function updateAreaStatus(success, customMessage = null) {
    const areaStatus = document.getElementById('areaStatus');
    const areaProgress = document.getElementById('areaProgress');
    const saveStatus = document.getElementById('saveStatus');

    if (success && calculatedArea > 0) {
        const areaDisplay = document.getElementById('calculatedArea');
        if (areaDisplay) {
            areaDisplay.textContent = calculatedArea.toLocaleString('id-ID', {maximumFractionDigits: 2}) + ' m²';
        }

        if (areaStatus) {
            areaStatus.textContent = customMessage || 'Area berhasil dihitung';
            areaStatus.className = 'text-success';
        }

        if (areaProgress) {
            areaProgress.style.width = '100%';
            areaProgress.className = 'progress-bar bg-success';
        }

        if (saveStatus) {
            saveStatus.textContent = 'Siap untuk disimpan';
            saveStatus.className = 'text-success';
        }
    } else {
        const areaDisplay = document.getElementById('calculatedArea');
        if (areaDisplay) {
            areaDisplay.textContent = '0 m²';
        }

        if (areaStatus) {
            areaStatus.textContent = customMessage || 'Minimal 3 titik diperlukan';
            areaStatus.className = 'text-warning';
        }

        if (areaProgress) {
            const progress = Math.min((coordinates.length / 3) * 100, 100);
            areaProgress.style.width = progress + '%';
            areaProgress.className = 'progress-bar bg-warning';
        }

        if (saveStatus) {
            saveStatus.textContent = 'Belum siap';
            saveStatus.className = 'text-warning';
        }
    }
}

// Update hidden inputs with current data
function updateHiddenInputs() {
    try {
        // Update coordinates data
        const coordinatesInput = document.getElementById('coordinates_input');
        if (coordinatesInput) {
            coordinatesInput.value = JSON.stringify(coordinates);
        }

            // Update lat[] and lng[] hidden inputs
            // Remove old hidden inputs first
            document.querySelectorAll('input[name^="lat["]').forEach(e => e.remove());
            document.querySelectorAll('input[name^="lng["]').forEach(e => e.remove());

            // Insert new hidden inputs for each coordinate
            const form = document.querySelector('form');
            if (form && Array.isArray(coordinates)) {
                coordinates.forEach((coord, idx) => {
                    if (typeof coord.lat === 'number' && typeof coord.lng === 'number') {
                        const latInput = document.createElement('input');
                        latInput.type = 'hidden';
                        latInput.name = `lat[${idx}]`;
                        latInput.value = coord.lat;
                        form.appendChild(latInput);

                        const lngInput = document.createElement('input');
                        lngInput.type = 'hidden';
                        lngInput.name = `lng[${idx}]`;
                        lngInput.value = coord.lng;
                        form.appendChild(lngInput);
                    }
                });
            }

        // Update calculated area
        const areaInput = document.getElementById('luas_terukur_otomatis');
        if (areaInput) {
            areaInput.value = calculatedArea;
        }

        // Update polygon bounds
        if (pengukuranPolygon) {
            const bounds = pengukuranPolygon.getBounds();
            const boundsInput = document.getElementById('polygon_bounds');
            if (boundsInput && bounds.isValid()) {
                boundsInput.value = JSON.stringify({
                    north: bounds.getNorth(),
                    south: bounds.getSouth(),
                    east: bounds.getEast(),
                    west: bounds.getWest()
                });
            }
        }

        // Auto-capture map setiap kali polygon berubah (jika ada minimal 3 koordinat)
        if (coordinates.length >= 3) {
            setTimeout(() => {
                autoCaptureMap();
            }, 800);
        }
    } catch (error) {
        console.error('Error updating hidden inputs:', error);
    }
}

// Calculate polygon area using Shoelace formula
function calculatePolygonArea() {
    if (coordinates.length < 3) return 0;

    try {
        let area = 0;
        const n = coordinates.length;

        for (let i = 0; i < n; i++) {
            const j = (i + 1) % n;
            area += coordinates[i].lat * coordinates[j].lng;
            area -= coordinates[j].lat * coordinates[i].lng;
        }

        area = Math.abs(area / 2);

        // Convert to square meters (approximation for Indonesia region)
        const latCenter = coordinates.reduce((sum, c) => sum + c.lat, 0) / n;
        const metersPerDegreeLng = 111319.9 * Math.cos(latCenter * Math.PI / 180);
        const metersPerDegreeLat = 111319.9;

        const areaInSquareMeters = area * metersPerDegreeLat * metersPerDegreeLng;

        return Math.round(areaInSquareMeters * 100) / 100;
    } catch (error) {
        console.error('Error calculating area:', error);
        return 0;
    }
}
</script>
<script>
// ============================================
// PART 7: ADD/REMOVE COORDINATES
// ============================================

// Add new coordinate row with optional UTM values
function addCoordinateWithValues(easting = '', northing = '') {
    coordinateCount++;
    const tbody = document.getElementById('coordinatesList');
    if (!tbody) {
        console.error('coordinatesList element not found');
        return;
    }

    const rowNumber = tbody.children.length + 1;

    const newRow = document.createElement('tr');
    newRow.id = `coord-${coordinateCount}`;
    newRow.innerHTML = `
        <td class="align-middle font-weight-bold">${rowNumber}</td>
        <td>
            <input type="text"
                   class="form-control form-control-sm"
                   id="easting_${coordinateCount}"
                   name="easting[${coordinateCount}]"
                   value="${easting}"
                   placeholder="Easting (m)"
                   onchange="updateFromUTM(${coordinateCount})"
                   onblur="validateCoordinateInput(this)">
        </td>
        <td>
            <input type="text"
                   class="form-control form-control-sm"
                   id="northing_${coordinateCount}"
                   name="northing[${coordinateCount}]"
                   value="${northing}"
                   placeholder="Northing (m)"
                   onchange="updateFromUTM(${coordinateCount})"
                   onblur="validateCoordinateInput(this)">
        </td>
        <td class="text-center">
            <button type="button"
                    onclick="removeCoordinate(${coordinateCount})"
                    class="btn btn-danger btn-sm"
                    title="Hapus">
                <i class="fas fa-times"></i>
            </button>
        </td>
    `;
    tbody.appendChild(newRow);

    // Update map if values provided
    if (easting && northing) {
        // Convert UTM to Lat/Lng for internal use
        const latLng = utmToLatLng(parseFloat(easting), parseFloat(northing));

        if (latLng) {
            setTimeout(updateMapAndCalculate, 100);

            // Auto check RTRW jika koordinat valid dan data RTRW sudah loaded
            if (rtrwData.length > 0) {
                setTimeout(() => {
                    if (isValidCoordinate(latLng.lat, latLng.lng)) {
                        const results = checkPointInRTRW(latLng.lat, latLng.lng);

                        if (results.length > 0 && typeof toastr !== 'undefined') {
                            toastr.success(
                                `Koordinat masuk di area: ${results.map(r => r.nama_rtrw).join(', ')}`,
                                'RTRW Ditemukan',
                                {timeOut: 3000, closeButton: true}
                            );
                        }
                    }
                }, 500);
            }
        }
    } else {
        // Focus on the first input if no values provided
        const newEastingInput = document.getElementById(`easting_${coordinateCount}`);
        if (newEastingInput) {
            newEastingInput.focus();
        }
    }
}

// Add coordinate (wrapper for addCoordinateWithValues)
function addCoordinate() {
    addCoordinateWithValues();
}

// Remove coordinate row
function removeCoordinate(id) {
    const row = document.getElementById(`coord-${id}`);
    if (!row) {
        console.warn('Row not found:', id);
        return;
    }

    // Optional: Don't allow removal if only 3 coordinates left (uncomment if needed)
    // const totalRows = document.querySelectorAll('#coordinatesList tr').length;
    // if (totalRows <= 3) {
    //     Swal.fire({
    //         icon: 'warning',
    //         title: 'Tidak Dapat Menghapus',
    //         text: 'Minimal 3 koordinat harus tetap ada',
    //         confirmButtonColor: '#ffc107'
    //     });
    //     return;
    // }

    Swal.fire({
        title: 'Hapus Koordinat?',
        text: 'Koordinat ini akan dihapus dari daftar',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="fas fa-trash"></i> Ya, Hapus',
        cancelButtonText: '<i class="fas fa-times"></i> Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            row.remove();

            // Re-number rows
            const rows = document.querySelectorAll('#coordinatesList tr');
            rows.forEach((row, index) => {
                const firstTd = row.querySelector('td:first-child');
                if (firstTd) {
                    firstTd.textContent = index + 1;
                }
            });

            setTimeout(updateMapAndCalculate, 100);

            if (typeof toastr !== 'undefined') {
                toastr.success('Koordinat berhasil dihapus', '', {timeOut: 2000});
            }
        }
    });
}
</script>
<script>
// ============================================
// PART 8: MAP UTILITY FUNCTIONS
// ============================================

// Enhanced center map function
function centerMap() {
    if (!pengukuranMap || !mapInitialized) {
        console.warn('Map not available for centering');
        Swal.fire({
            icon: 'warning',
            title: 'Peta Belum Siap',
            text: 'Silakan tunggu peta dimuat terlebih dahulu',
            confirmButtonColor: '#ffc107'
        });
        return;
    }

    try {
        if (pengukuranPolygon) {
            const bounds = pengukuranPolygon.getBounds();
            if (bounds.isValid()) {
                pengukuranMap.fitBounds(bounds, {padding: [50, 50]});
                return;
            }
        }

        if (pengukuranMarkers.length > 0) {
            const group = new L.featureGroup(pengukuranMarkers);
            pengukuranMap.fitBounds(group.getBounds(), {padding: [50, 50]});
            return;
        }

        // Reset to default center
        const defaultCenter = coordinates.length > 0
            ? [coordinates[0].lat, coordinates[0].lng]
            : [-1.2417, 116.8730];
        pengukuranMap.setView(defaultCenter, 18);

    } catch (error) {
        console.error('Error centering map:', error);
        try {
            pengukuranMap.setView([-1.2417, 116.8730], 18);
        } catch (fallbackError) {
            console.error('Error with fallback center:', fallbackError);
        }
    }
}
</script>
<script>
// ============================================
// PART 9: MAP CAPTURE FUNCTIONALITY
// ============================================

// Enhanced map capture function with polygon support
function captureMap() {
    if (!pengukuranMap || !mapInitialized) {
        Swal.fire({
            icon: 'warning',
            title: 'Peta Belum Siap',
            text: 'Silakan tunggu peta dimuat terlebih dahulu',
            confirmButtonColor: '#ffc107'
        });
        return false;
    }

    if (coordinates.length < 3) {
        Swal.fire({
            icon: 'warning',
            title: 'Koordinat Tidak Cukup',
            text: 'Harap tambahkan minimal 3 koordinat sebelum capture peta',
            confirmButtonColor: '#dc3545'
        });
        return false;
    }

    const saveStatus = document.getElementById('saveStatus');
    if (saveStatus) {
        saveStatus.textContent = 'Sedang capture peta...';
        saveStatus.className = 'text-info';
    }

    // Use manual canvas drawing for reliability
    const result = createManualMapImage();

    if (result) {
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: 'Peta berhasil di-capture',
            timer: 2000,
            showConfirmButton: false
        });
    }

    return result;
}

// Auto-capture map (tanpa alert, untuk otomatis)
function autoCaptureMap() {
    if (!pengukuranMap || !mapInitialized) {
        console.warn('Map not ready for auto-capture');
        return false;
    }

    if (coordinates.length < 3) {
        console.warn('Not enough coordinates for auto-capture');
        return false;
    }

    console.log('Auto-capturing map...');
    const result = createManualMapImage();

    if (result) {
        console.log('✓ Map auto-captured successfully');
        const saveStatus = document.getElementById('saveStatus');
        if (saveStatus) {
            saveStatus.textContent = 'Peta ter-capture otomatis';
            saveStatus.className = 'text-success';
        }
    }

    return result;
}

// Create manual map image by drawing on canvas
function createManualMapImage() {
    const saveStatus = document.getElementById('saveStatus');

    try {
        const canvas = document.createElement('canvas');
        canvas.width = 800;
        canvas.height = 600;
        const ctx = canvas.getContext('2d');

        // Set background with subtle gradient
        const gradient = ctx.createLinearGradient(0, 0, 0, canvas.height);
        gradient.addColorStop(0, '#f8f9fa');
        gradient.addColorStop(1, '#e9ecef');
        ctx.fillStyle = gradient;
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        if (coordinates.length >= 3) {
            // Calculate bounds
            const lats = coordinates.map(c => c.lat);
            const lngs = coordinates.map(c => c.lng);
            const minLat = Math.min(...lats);
            const maxLat = Math.max(...lats);
            const minLng = Math.min(...lngs);
            const maxLng = Math.max(...lngs);

            // Add padding
            const latPadding = (maxLat - minLat) * 0.15 || 0.002;
            const lngPadding = (maxLng - minLng) * 0.15 || 0.002;

            // Map coordinates to canvas
            function mapToCanvas(lat, lng) {
                const x = ((lng - minLng + lngPadding) / (maxLng - minLng + 2 * lngPadding)) * (canvas.width - 60) + 30;
                const y = ((maxLat - lat + latPadding) / (maxLat - minLat + 2 * latPadding)) * (canvas.height - 100) + 50;
                return { x, y };
            }

            // Draw subtle grid lines
            ctx.strokeStyle = '#dee2e6';
            ctx.lineWidth = 0.5;
            ctx.setLineDash([2, 2]);

            for (let i = 1; i < 8; i++) {
                const x = 30 + ((canvas.width - 60) / 8) * i;
                const y = 50 + ((canvas.height - 100) / 8) * i;

                ctx.beginPath();
                ctx.moveTo(x, 50);
                ctx.lineTo(x, canvas.height - 50);
                ctx.stroke();

                ctx.beginPath();
                ctx.moveTo(30, y);
                ctx.lineTo(canvas.width - 30, y);
                ctx.stroke();
            }

            // Draw coordinate lines to each point
            ctx.strokeStyle = '#6c757d';
            ctx.lineWidth = 1;
            ctx.setLineDash([3, 3]);

            coordinates.forEach((coord) => {
                const point = mapToCanvas(coord.lat, coord.lng);

                // Vertical line
                ctx.beginPath();
                ctx.moveTo(point.x, 50);
                ctx.lineTo(point.x, canvas.height - 50);
                ctx.stroke();

                // Horizontal line
                ctx.beginPath();
                ctx.moveTo(30, point.y);
                ctx.lineTo(canvas.width - 30, point.y);
                ctx.stroke();
            });

            // Draw polygon fill
            ctx.fillStyle = 'rgba(40, 167, 69, 0.25)';
            ctx.strokeStyle = '#28a745';
            ctx.lineWidth = 3;
            ctx.setLineDash([8, 4]);

            ctx.beginPath();
            coordinates.forEach((coord, index) => {
                const point = mapToCanvas(coord.lat, coord.lng);
                if (index === 0) {
                    ctx.moveTo(point.x, point.y);
                } else {
                    ctx.lineTo(point.x, point.y);
                }
            });
            ctx.closePath();
            ctx.fill();
            ctx.stroke();

            // Draw polygon outline (solid)
            ctx.strokeStyle = '#28a745';
            ctx.lineWidth = 2;
            ctx.setLineDash([]);
            ctx.stroke();

            // Draw connecting lines between points
            ctx.strokeStyle = '#17a2b8';
            ctx.lineWidth = 2;

            coordinates.forEach((coord, index) => {
                if (index < coordinates.length - 1) {
                    const point1 = mapToCanvas(coord.lat, coord.lng);
                    const point2 = mapToCanvas(coordinates[index + 1].lat, coordinates[index + 1].lng);

                    ctx.beginPath();
                    ctx.moveTo(point1.x, point1.y);
                    ctx.lineTo(point2.x, point2.y);
                    ctx.stroke();
                }
            });

            // Draw closing line
            const firstPoint = mapToCanvas(coordinates[0].lat, coordinates[0].lng);
            const lastPoint = mapToCanvas(coordinates[coordinates.length - 1].lat, coordinates[coordinates.length - 1].lng);

            ctx.beginPath();
            ctx.moveTo(lastPoint.x, lastPoint.y);
            ctx.lineTo(firstPoint.x, firstPoint.y);
            ctx.stroke();

            // Draw markers with shadows
            coordinates.forEach((coord, index) => {
                const point = mapToCanvas(coord.lat, coord.lng);

                // Draw shadow
                ctx.fillStyle = 'rgba(0, 0, 0, 0.2)';
                ctx.beginPath();
                ctx.arc(point.x + 2, point.y + 2, 16, 0, 2 * Math.PI);
                ctx.fill();

                // Draw marker circle
                ctx.fillStyle = '#28a745';
                ctx.strokeStyle = '#ffffff';
                ctx.lineWidth = 3;
                ctx.setLineDash([]);

                ctx.beginPath();
                ctx.arc(point.x, point.y, 16, 0, 2 * Math.PI);
                ctx.fill();
                ctx.stroke();

                // Draw number
                ctx.fillStyle = '#ffffff';
                ctx.font = 'bold 14px Arial';
                ctx.textAlign = 'center';
                ctx.textBaseline = 'middle';
                ctx.fillText((index + 1).toString(), point.x, point.y);

                // Add coordinate label
                ctx.fillStyle = '#495057';
                ctx.font = '9px Arial';
                ctx.textAlign = 'center';
                ctx.fillText(
                    `${coord.lat.toFixed(6)}, ${coord.lng.toFixed(6)}`,
                    point.x,
                    point.y + 30
                );
            });

            // Add border
            ctx.strokeStyle = '#495057';
            ctx.lineWidth = 2;
            ctx.setLineDash([]);
            ctx.strokeRect(2, 2, canvas.width - 4, canvas.height - 4);
        }

        // Add header with title
        ctx.fillStyle = '#ffffff';
        ctx.fillRect(0, 0, canvas.width, 45);
        ctx.strokeStyle = '#dee2e6';
        ctx.lineWidth = 1;
        ctx.strokeRect(0, 0, canvas.width, 45);

        ctx.fillStyle = '#212529';
        ctx.font = 'bold 18px Arial';
        ctx.textAlign = 'center';
        ctx.fillText('PETA KOORDINAT PENGUKURAN BIDANG TANAH', canvas.width / 2, 28);

        // Add footer with information
        ctx.fillStyle = '#ffffff';
        ctx.fillRect(0, canvas.height - 50, canvas.width, 50);
        ctx.strokeRect(0, canvas.height - 50, canvas.width, 50);

        // Left side info
        ctx.fillStyle = '#495057';
        ctx.font = 'bold 12px Arial';
        ctx.textAlign = 'left';
        ctx.fillText(`Luas Area: ${calculatedArea.toLocaleString('id-ID')} m²`, 20, canvas.height - 30);
        ctx.fillText(`Jumlah Titik: ${coordinates.length}`, 20, canvas.height - 15);

        // Center info
        ctx.textAlign = 'center';
        ctx.fillText('Sistem Koordinat: UTM', canvas.width / 2, canvas.height - 30);
        ctx.fillText(`Skala: 1:${Math.round(1000 + coordinates.length * 100)}`, canvas.width / 2, canvas.height - 15);

        // Right side info
        ctx.textAlign = 'right';
        const now = new Date();
        ctx.fillText(`Tanggal: ${now.toLocaleDateString('id-ID')}`, canvas.width - 20, canvas.height - 30);
        ctx.fillText(`Waktu: ${now.toLocaleTimeString('id-ID')}`, canvas.width - 20, canvas.height - 15);

        // Save the image
        const imageData = canvas.toDataURL('image/png');
        const mapImageInput = document.getElementById('map_image_data');
        if (mapImageInput) {
            mapImageInput.value = imageData;
            console.log('✓ Map image saved to hidden input, size:', imageData.length, 'bytes');
        }

        if (saveStatus) {
            saveStatus.textContent = 'Peta berhasil di-capture!';
            saveStatus.className = 'text-success';
        }

        console.log('Map captured successfully');
        return true; // Return success

    } catch (error) {
        console.error('Error creating manual map image:', error);

        if (saveStatus) {
            saveStatus.textContent = 'Error capture peta';
            saveStatus.className = 'text-danger';
        }

        Swal.fire({
            icon: 'error',
            title: 'Gagal Capture',
            text: 'Terjadi kesalahan saat capture peta: ' + error.message,
            confirmButtonColor: '#dc3545'
        });

        return false; // Return failure
    }
}
            saveStatus.className = 'text-danger';
        }

        // Fallback to simple data storage
        fallbackCapture();
    }
}

// Fallback capture method
function fallbackCapture() {
    try {
        const mapData = {
            coordinates: coordinates,
            bounds: pengukuranPolygon ? pengukuranPolygon.getBounds() : null,
            center: pengukuranMap ? pengukuranMap.getCenter() : null,
            zoom: pengukuranMap ? pengukuranMap.getZoom() : 18,
            calculatedArea: calculatedArea,
            timestamp: new Date().toISOString(),
            mode: 'edit'
        };

        const mapImageInput = document.getElementById('map_image_data');
        if (mapImageInput) {
            mapImageInput.value = JSON.stringify(mapData);
        }

        const saveStatus = document.getElementById('saveStatus');
        if (saveStatus) {
            saveStatus.textContent = 'Data peta berhasil disimpan';
            saveStatus.className = 'text-success';
        }
    } catch (error) {
        console.error('Error in fallback capture:', error);
        const saveStatus = document.getElementById('saveStatus');
        if (saveStatus) {
            saveStatus.textContent = 'Error menyimpan data peta';
            saveStatus.className = 'text-danger';
        }
    }
}
</script>
<script>
// ============================================
// PART 10: RTRW FUNCTIONS - DATA LOADING
// ============================================

// Load RTRW data dari database
async function loadRTRWData() {
    try {
        const response = await fetch('{{ route("rtrw.api.all") }}');
        if (!response.ok) {
            throw new Error('Gagal memuat data RTRW: ' + response.statusText);
        }

        rtrwData = await response.json();
        console.log('RTRW data loaded:', rtrwData.length, 'areas');

        // Validasi data RTRW
        if (!Array.isArray(rtrwData)) {
            console.error('Invalid RTRW data format');
            rtrwData = [];
            return [];
        }

        // Tampilkan RTRW overlay di map
        displayRTRWOverlay();

        // Update summary
        updateRTRWSummary();

        return rtrwData;
    } catch (error) {
        console.error('Error loading RTRW data:', error);

        // Show error notification
        if (typeof toastr !== 'undefined') {
            toastr.error('Gagal memuat data RTRW', '', {timeOut: 3000});
        }

        return [];
    }
}

// Tampilkan RTRW sebagai overlay di map
function displayRTRWOverlay() {
    if (!pengukuranMap || !mapInitialized || rtrwData.length === 0) {
        console.log('Cannot display RTRW overlay - map not ready or no data');
        return;
    }

    // Hapus layer RTRW yang lama
    rtrwLayers.forEach(layer => {
        try {
            if (pengukuranMap.hasLayer(layer)) {
                pengukuranMap.removeLayer(layer);
            }
        } catch (e) {
            console.warn('Error removing RTRW layer:', e);
        }
    });
    rtrwLayers = [];

    // Tambahkan layer RTRW baru
    rtrwData.forEach(rtrw => {
        try {
            if (!rtrw.geojson) {
                console.warn('RTRW without geojson:', rtrw.nama_rtrw);
                return;
            }

            const geojson = typeof rtrw.geojson === 'string'
                ? JSON.parse(rtrw.geojson)
                : rtrw.geojson;

            const layer = L.geoJSON(geojson, {
                style: {
                    color: rtrw.warna || '#3388ff',
                    weight: 2,
                    opacity: 0.6,
                    fillColor: rtrw.warna || '#3388ff',
                    fillOpacity: 0.1,
                    dashArray: '5, 10'
                },
                onEachFeature: function(feature, layer) {
                    layer.bindPopup(`
                        <div style="font-family: Arial, sans-serif;">
                            <strong style="color: ${rtrw.warna}; font-size: 14px;">
                                ${rtrw.nama_rtrw}
                            </strong>
                            <hr style="margin: 5px 0;">
                            <div style="font-size: 12px;">
                                <div style="margin: 3px 0;">
                                    <strong>Warna:</strong>
                                    <span style="display: inline-block; width: 20px; height: 12px; background: ${rtrw.warna}; border: 1px solid #ccc; vertical-align: middle;"></span>
                                    ${rtrw.warna}
                                </div>
                            </div>
                        </div>
                    `);
                }
            });

            layer.addTo(pengukuranMap);
            rtrwLayers.push(layer);

        } catch (error) {
            console.error('Error displaying RTRW:', rtrw.nama_rtrw, error);
        }
    });

    console.log('RTRW overlay displayed:', rtrwLayers.length, 'layers');
}
</script>
<script>
// ============================================
// PART 11: RTRW FUNCTIONS - POINT CHECKING
// ============================================

// Cek apakah titik berada dalam polygon RTRW menggunakan Turf.js
function checkPointInRTRW(lat, lng) {
    if (!window.turf) {
        console.error('Turf.js not loaded');
        return [];
    }

    const point = turf.point([lng, lat]);
    const results = [];

    rtrwData.forEach(rtrw => {
        try {
            if (!rtrw.geojson) return;

            const geojson = typeof rtrw.geojson === 'string'
                ? JSON.parse(rtrw.geojson)
                : rtrw.geojson;

            // Handle FeatureCollection
            if (geojson.type === 'FeatureCollection') {
                geojson.features.forEach(feature => {
                    if (turf.booleanPointInPolygon(point, feature)) {
                        if (!results.find(r => r.id === rtrw.id)) {
                            results.push(rtrw);
                        }
                    }
                });
            }
            // Handle single Feature
            else if (geojson.type === 'Feature') {
                if (turf.booleanPointInPolygon(point, geojson)) {
                    results.push(rtrw);
                }
            }
            // Handle direct Geometry
            else if (geojson.type === 'Polygon' || geojson.type === 'MultiPolygon') {
                const feature = turf.feature(geojson);
                if (turf.booleanPointInPolygon(point, feature)) {
                    results.push(rtrw);
                }
            }
        } catch (error) {
            console.error('Error checking RTRW:', rtrw.nama_rtrw, error);
        }
    });

    return results;
}

// Tampilkan popup informasi RTRW
function showRTRWPopup(rtrwList, lat, lng) {
    if rtrwList.length === 0) {
        Swal.fire({
            icon: 'info',
            title: 'Lokasi Koordinat',
            html: `
                <div style="text-align: left;">
                    <p><strong>Koordinat:</strong></p>
                    <p>Latitude: ${lat.toFixed(8)}</p>
                    <p><strong>Longitude:</strong> ${lng.toFixed(8)}</p>
                    <hr>
                    <p style="color: #6c757d;">
                        <i class="fas fa-info-circle"></i>
                        Titik ini <strong>tidak berada</strong> dalam area RTRW yang terdaftar
                    </p>
                </div>
            `,
            confirmButtonColor: '#007bff',
            confirmButtonText: 'OK'
        });
    } else {
        const areasHTML = rtrwList.map(rtrw => `
            <div style="border: 2px solid ${rtrw.warna}; padding: 10px; margin: 8px 0; border-radius: 6px; background: ${rtrw.warna}15;">
                <div style="display: flex; align-items: center; margin-bottom: 5px;">
                    <div style="width: 30px; height: 30px; background: ${rtrw.warna}; border-radius: 4px; margin-right: 10px; border: 2px solid white; box-shadow: 0 2px 4px rgba(0,0,0,0.2);"></div>
                    <strong style="font-size: 12px; color: ${rtrw.warna};">${rtrw.nama_rtrw}</strong>
                </div>
                <div style="font-size: 13px; color: #495057; margin-left: 40px;">
                    <div><i class="fas fa-palette"></i> Warna: ${rtrw.warna}</div>
                </div>
            </div>
        `).join('');

        Swal.fire({
            icon: 'success',
            title: '<i class="fas fa-map-marked-alt"></i> Wilayah Ditemukan!',
            html: `
                <div style="text-align: left;">
                    <div style="background: #e7f3ff; padding: 10px; border-radius: 6px; margin-bottom: 15px;">
                        <p style="margin: 5px 0;"><strong>Koordinat:</strong></p>
                        <p style="margin: 5px 0; font-family: monospace;">Lat: ${lat.toFixed(8)}</p>
                        <p style="margin: 5px 0; font-family: monospace;">Lng: ${lng.toFixed(8)}</p>
                    </div>
                    <hr>
                    <p style="margin: 10px 0;"><strong>Titik ini berada di area:</strong></p>
                    ${areasHTML}
                    <div style="margin-top: 15px; padding: 10px; background: #fff3cd; border-radius: 6px; border-left: 4px solid #ffc107;">
                        <small style="color: #856404;">
                            <i class="fas fa-info-circle"></i>
                            Ditemukan ${rtrwList.length} wilayah RTRW
                        </small>
                    </div>
                </div>
            `,
            width: '600px',
            confirmButtonColor: '#28a745',
            confirmButtonText: '<i class="fas fa-check"></i> Mengerti'
        });
    }
}
</script>
<script>
// ============================================
// PART 12: RTRW FUNCTIONS - ANALYSIS
// ============================================

// Check all coordinates against RTRW
function checkAllCoordinatesRTRW() {
    if (coordinates.length === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Tidak Ada Koordinat',
            text: 'Silakan tambahkan koordinat terlebih dahulu',
            confirmButtonColor: '#ffc107'
        });
        return;
    }

    if (rtrwData.length === 0) {
        Swal.fire({
            icon: 'info',
            title: 'Data RTRW Kosong',
            text: 'Tidak ada data RTRW yang tersimpan di database',
            confirmButtonColor: '#17a2b8'
        });
        return;
    }

    isCheckingRTRW = true;

    // Analisis semua koordinat
    const analysis = {
        totalPoints: coordinates.length,
        pointsInArea: 0,
        pointsOutside: 0,
        areas: {}
    };

    coordinates.forEach((coord, index) => {
        const results = checkPointInRTRW(coord.lat, coord.lng);

        if (results.length > 0) {
            analysis.pointsInArea++;
            results.forEach(rtrw => {
                if (!analysis.areas[rtrw.nama_rtrw]) {
                    analysis.areas[rtrw.nama_rtrw] = {
                        info: rtrw,
                        points: []
                    };
                }
                analysis.areas[rtrw.nama_rtrw].points.push(index + 1);
            });
        } else {
            analysis.pointsOutside++;
        }
    });

    // Generate summary HTML
    const areasHTML = Object.entries(analysis.areas).map(([name, data]) => `
        <div style="border: 2px solid ${data.info.warna}; padding: 12px; margin: 10px 0; border-radius: 8px; background: ${data.info.warna}15;">
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <div style="width: 35px; height: 35px; background: ${data.info.warna}; border-radius: 6px; margin-right: 12px; border: 2px solid white; box-shadow: 0 2px 6px rgba(0,0,0,0.2);"></div>
                <div>
                    <strong style="font-size: 16px; color: ${data.info.warna};">${name}</strong>
                    <div style="font-size: 12px; color: #6c757d;">${data.info.warna}</div>
                </div>
            </div>
            <div style="margin-left: 47px; font-size: 13px;">
                <div style="background: white; padding: 8px; border-radius: 4px; margin-top: 5px;">
                    <i class="fas fa-map-pin" style="color: ${data.info.warna};"></i>
                    <strong>Titik yang masuk:</strong> ${data.points.join(', ')}
                    <span style="float: right; background: ${data.info.warna}; color: white; padding: 2px 8px; border-radius: 12px; font-size: 11px;">
                        ${data.points.length} titik
                    </span>
                </div>
            </div>
        </div>
    `).join('');

    const summaryHTML = `
        <div style="text-align: left;">
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-bottom: 20px;">
                <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 15px; border-radius: 8px; color: white; text-align: center;">
                    <div style="font-size: 28px; font-weight: bold;">${analysis.totalPoints}</div>
                    <div style="font-size: 12px; opacity: 0.9;">Total Titik</div>
                </div>
                <div style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); padding: 15px; border-radius: 8px; color: white; text-align: center;">
                    <div style="font-size: 28px; font-weight: bold;">${analysis.pointsInArea}</div>
                    <div style="font-size: 12px; opacity: 0.9;">Dalam Area</div>
                </div>
                <div style="background: linear-gradient(135deg, #ffc107 0%, #ff6b6b 100%); padding: 15px; border-radius: 8px; color: white; text-align: center;">
                    <div style="font-size: 28px; font-weight: bold;">${analysis.pointsOutside}</div>
                    <div style="font-size: 12px; opacity: 0.9;">Di Luar Area</div>
                </div>
            </div>

            ${Object.keys(analysis.areas).length > 0 ? `
                <hr style="margin: 15px 0;">
                <h6 style="color: #495057; margin-bottom: 15px;">
                    <i class="fas fa-layer-group"></i> Detail Wilayah RTRW:
                </h6>
                ${areasHTML}
            ` : `
                <div style="padding: 20px; background: #fff3cd; border-radius: 8px; text-align: center; border-left: 4px solid #ffc107;">
                    <i class="fas fa-exclamation-triangle" style="font-size: 24px; color: #856404; margin-bottom: 10px;"></i>
                    <p style="color: #856404; margin: 0;">Tidak ada titik yang berada dalam area RTRW yang terdaftar</p>
                </div>
            `}

            ${analysis.pointsOutside > 0 ? `
                <div style="margin-top: 15px; padding: 12px; background: #f8d7da; border-radius: 6px; border-left: 4px solid #dc3545;">
                    <small style="color: #721c24;">
                        <i class="fas fa-info-circle"></i>
                        <strong>Perhatian:</strong> ${analysis.pointsOutside} titik berada di luar semua area RTRW
                    </small>
                </div>
            ` : ''}
        </div>
    `;

    Swal.fire({
        icon: analysis.pointsInArea > 0 ? 'success' : 'warning',
        title: '<i class="fas fa-chart-pie"></i> Analisis Wilayah RTRW',
        html: summaryHTML,
        width: '700px',
        confirmButtonColor: analysis.pointsInArea > 0 ? '#28a745' : '#ffc107',
        confirmButtonText: '<i class="fas fa-check-circle"></i> Mengerti',
        showCloseButton: true
    });

    isCheckingRTRW = false;
}
</script>
<script>
// ============================================
// PART 13: RTRW UI & CONTROLS
// ============================================

// Toggle visibility RTRW overlay
function toggleRTRWOverlay() {
    if (!pengukuranMap || !mapInitialized) {
        Swal.fire({
            icon: 'warning',
            title: 'Peta Belum Siap',
            text: 'Silakan tunggu peta dimuat terlebih dahulu',
            confirmButtonColor: '#ffc107'
        });
        return;
    }

    rtrwOverlayVisible = !rtrwOverlayVisible;

    rtrwLayers.forEach(layer => {
        try {
            if (rtrwOverlayVisible) {
                if (!pengukuranMap.hasLayer(layer)) {
                    layer.addTo(pengukuranMap);
                }
            } else {
                if (pengukuranMap.hasLayer(layer)) {
                    pengukuranMap.removeLayer(layer);
                }
            }
        } catch (e) {
            console.warn('Error toggling RTRW layer:', e);
        }
    });

    // Update summary
    const activeOverlaysEl = document.getElementById('activeOverlays');
    if (activeOverlaysEl) {
        activeOverlaysEl.textContent = rtrwOverlayVisible ? rtrwData.length : 0;
    }

    if (typeof toastr !== 'undefined') {
        toastr.info(
            `RTRW Overlay ${rtrwOverlayVisible ? 'ditampilkan' : 'disembunyikan'}`,
            '',
            {timeOut: 1500}
        );
    }
}

// Update RTRW Summary
function updateRTRWSummary() {
    const summaryDiv = document.getElementById('rtrwSummary');
    const legendDiv = document.getElementById('rtrwLegend');

    if (!summaryDiv || !legendDiv) {
        console.warn('RTRW summary elements not found');
        return;
    }

    if (rtrwData.length === 0) {
        summaryDiv.innerHTML = `
            <div class="text-center text-muted py-3">
                <i class="fas fa-exclamation-triangle fa-2x mb-2"></i>
                <p class="mb-0 small">Tidak ada data RTRW yang tersimpan</p>
                <a href="{{ route('rtrw.create') }}" class="btn btn-sm btn-primary mt-2" target="_blank">
                    <i class="fas fa-plus"></i> Tambah RTRW
                </a>
            </div>
        `;
        legendDiv.innerHTML = '<div class="col-12 text-center text-muted">Belum ada data RTRW</div>';
        return;
    }

    // Summary statistics
    summaryDiv.innerHTML = `
        <div class="row text-center">
            <div class="col-6 mb-2">
                <div style="background: linear-gradient(135deg, #4e73df, #224abe); padding: 15px; border-radius: 8px; color: white;">
                    <h3 class="mb-0">${rtrwData.length}</h3>
                    <small style="opacity: 0.9;">Total Wilayah</small>
                </div>
            </div>
            <div class="col-6 mb-2">
                <div style="background: linear-gradient(135deg, #1cc88a, #13855c); padding: 15px; border-radius: 8px; color: white;">
                    <h3 class="mb-0" id="activeOverlays">${rtrwOverlayVisible ? rtrwData.length : 0}</h3>
                    <small style="opacity: 0.9;">Overlay Aktif</small>
                </div>
            </div>
        </div>
        <div class="mt-2 small text-muted text-center">
            <i class="fas fa-info-circle"></i> Klik "Analisis" untuk pengecekan detail
        </div>
    `;

    // Legend items
    legendDiv.innerHTML = rtrwData.map(rtrw => `
        <div class="col-md-6 col-lg-4 mb-2">
            <div class="rtrw-legend-item" onclick="focusRTRW('${rtrw.id}')" style="cursor: pointer;">
                <div style="width: 20px; height: 20px; background-color: ${rtrw.warna}; border-radius: 3px; margin-right: 8px; border: 1px solid #dee2e6;"></div>
                <div class="rtrw-legend-name">${rtrw.nama_rtrw}</div>
                <div class="rtrw-legend-code">${rtrw.warna}</div>
            </div>
        </div>
    `).join('');
}

// Focus map ke wilayah RTRW tertentu
function focusRTRW(rtrwId) {
    if (!pengukuranMap || !mapInitialized) {
        Swal.fire({
            icon: 'warning',
            title: 'Peta Belum Siap',
            text: 'Silakan tunggu peta dimuat terlebih dahulu',
            confirmButtonColor: '#ffc107'
        });
        return;
    }

    const rtrw = rtrwData.find(r => r.id == rtrwId);
    if (!rtrw) {
        console.warn('RTRW not found:', rtrwId);
        return;
    }

    // Find matching layer
    const matchingLayer = rtrwLayers.find((layer, index) => {
        return rtrwData[index] && rtrwData[index].id == rtrwId;
    });

    if (matchingLayer) {
        try {
            const bounds = matchingLayer.getBounds();
            if (bounds.isValid()) {
                pengukuranMap.fitBounds(bounds, {padding: [50, 50]});

                // Open popup if available
                if (matchingLayer.openPopup) {
                    matchingLayer.openPopup();
                }

                if (typeof toastr !== 'undefined') {
                    toastr.info(`Fokus pada: ${rtrw.nama_rtrw}`, '', {timeOut: 2000});
                }
            }
        } catch (error) {
            console.error('Error focusing RTRW:', error);
        }
    } else {
        console.warn('Layer not found for RTRW:', rtrw.nama_rtrw);
    }
}

// Add RTRW toggle button to map
function addRTRWToggleButton() {
    if (!pengukuranMap || !mapInitialized) {
        console.warn('Cannot add RTRW button - map not ready');
        return;
    }

    try {
        const RTRWControl = L.Control.extend({
            options: {
                position: 'topright'
            },
            onAdd: function(map) {
                const container = L.DomUtil.create('div', 'leaflet-bar leaflet-control');
                container.style.background = 'white';
                container.style.padding = '0';
                container.style.cursor = 'pointer';
                container.innerHTML = `
                    <button onclick="toggleRTRWOverlay()"
                            style="border: none; background: white; cursor: pointer; padding: 8px 12px; font-size: 12px; display: block; width: 100%; text-align: left;"
                            title="Toggle RTRW Overlay">
                        <i class="fas fa-layer-group"></i> RTRW
                    </button>
                    <button onclick="checkAllCoordinatesRTRW()"
                            style="border: none; background: white; cursor: pointer; padding: 8px 12px; font-size: 12px; border-top: 1px solid #ccc; display: block; width: 100%; text-align: left;"
                            title="Analisis Wilayah">
                        <i class="fas fa-search-location"></i> Analisis
                    </button>
                `;

                // Prevent map click when clicking buttons
                L.DomEvent.disableClickPropagation(container);

                return container;
            }
        });

        pengukuranMap.addControl(new RTRWControl());
        console.log('RTRW control button added');

    } catch (error) {
        console.error('Error adding RTRW toggle button:', error);
    }
}
</script>
<script>
// ============================================
// PART 14: NAVIGATION & FORM FUNCTIONS
// ============================================

// Navigation functions
function nextTab() {
    const activeTab = $('.nav-tabs .nav-link.active');
    const nextTab = activeTab.parent().next().find('.nav-link');

    if (nextTab.length > 0) {
        nextTab.tab('show');
        window.scrollTo({ top: 0, behavior: 'smooth' });
    } else {
        console.log('This is the last tab');
        if (typeof toastr !== 'undefined') {
            toastr.info('Ini adalah tab terakhir', '', {timeOut: 2000});
        }
    }
}

function previousTab() {
    const activeTab = $('.nav-tabs .nav-link.active');
    const prevTab = activeTab.parent().prev().find('.nav-link');

    if (prevTab.length > 0) {
        prevTab.tab('show');
        window.scrollTo({ top: 0, behavior: 'smooth' });
    } else {
        console.log('This is the first tab');
        if (typeof toastr !== 'undefined') {
            toastr.info('Ini adalah tab pertama', '', {timeOut: 2000});
        }
    }
}
// function autoCaptureMap() {
//     if (!pengukuranMap || !mapInitialized || coordinates.length < 3) {
//         Swal.fire({
//             icon: 'warning',
//             title: 'Capture Gagal',
//             text: 'Harap tambahkan minimal 3 koordinat sebelum capture peta',
//             confirmButtonColor: '#dc3545',
//             confirmButtonText: '<i class="fas fa-times"></i> Tutup',
//             width: '400px'
//         });
//         return;
//     }

//     const saveStatus = document.getElementById('saveStatus');
//     if (saveStatus) {
//         saveStatus.textContent = 'Sedang capture peta...';
//         saveStatus.className = 'text-info';
//     }

//     // Use manual canvas drawing as primary method for reliability
//     createManualMapImage();
// }
// Save draft function
function saveDraft() {
    const form = document.querySelector('form');
    if (!form) {
        console.error('Form not found');
        return;
    }

    const formData = new FormData(form);
    formData.append('save_as_draft', '1');

    // Add coordinates if available
    if (coordinates.length > 0) {
        formData.set('coordinates_data', JSON.stringify(coordinates));
    }

    // Add calculated area
    if (calculatedArea > 0) {
        formData.set('luas_terukur_otomatis', calculatedArea);
    }

    // Show loading
    const draftBtn = $('button:contains("Simpan Draft")');
    const originalText = draftBtn.html();
    draftBtn.html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...').prop('disabled', true);

    $.ajax({
        url: window.location.href,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') || $('input[name="_token"]').val()
        },
        success: function(response) {
            if (typeof toastr !== 'undefined') {
                toastr.success('Draft berhasil disimpan!');
            } else {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: 'Draft berhasil disimpan',
                    timer: 2000,
                    showConfirmButton: false
                });
            }

            // Mark form as unchanged
            if (typeof formChanged !== 'undefined') {
                formChanged = false;
            }
        },
        error: function(xhr) {
            console.error('Save draft error:', xhr);
            let errorMsg = 'Gagal menyimpan draft';

            if (xhr.status === 422) {
                const errors = xhr.responseJSON?.errors;
                if (errors) {
                    errorMsg = 'Validation errors: ' + Object.values(errors).flat().join(', ');
                }
            } else if (xhr.status === 419) {
                errorMsg = 'Session expired. Silakan refresh halaman.';
            } else if (xhr.responseJSON?.message) {
                errorMsg = xhr.responseJSON.message;
            }

            if (typeof toastr !== 'undefined') {
                toastr.error(errorMsg);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: errorMsg,
                    confirmButtonColor: '#dc3545'
                });
            }
        },
        complete: function() {
            draftBtn.html(originalText).prop('disabled', false);
        }
    });
}
</script>
<script>
// ============================================
// PART 15: DOCUMENT READY & EVENT HANDLERS
// ============================================

// Initialize when document ready
$(document).ready(function() {
    console.log('Document ready - Edit mode');

    // Initialize map when pengukuran tab is shown
    $('a[href="#pengukuran"]').on('shown.bs.tab', function() {
        console.log('Pengukuran tab shown');
        setTimeout(function() {
            if (!mapInitialized) {
                initPengukuranMap();
            } else {
                // Just update if already initialized
                updateMapAndCalculate();

                // Reload RTRW if needed
                if (rtrwData.length === 0) {
                    loadRTRWData();
                }
            }
        }, 100);
    });

    // Check if pengukuran tab is already active on load
    if ($('#pengukuran').hasClass('active') || $('#pengukuran').hasClass('show')) {
        console.log('Pengukuran tab already active, initializing...');
        setTimeout(function() {
            initPengukuranMap();
        }, 500);
    }

    // Handle online/offline status
    window.addEventListener('online', function() {
        console.log('Connection restored');
        if (pengukuranMap && mapInitialized) {
            pengukuranMap.eachLayer(function(layer) {
                if (layer.options && layer.options.attribution) {
                    try {
                        layer.redraw();
                    } catch (e) {
                        console.warn('Error redrawing layer:', e);
                    }
                }
            });
        }

        if (typeof toastr !== 'undefined') {
            toastr.success('Koneksi internet tersambung', '', {timeOut: 2000});
        }
    });

    window.addEventListener('offline', function() {
        console.log('Connection lost');
        if (typeof toastr !== 'undefined') {
            toastr.warning('Koneksi internet terputus', '', {timeOut: 3000});
        }
    });

    // Auto-save coordinates when they change (debounced)
    let autoSaveTimeout;
    $(document).on('change', 'input[name^="lat"], input[name^="lng"]', function() {
        clearTimeout(autoSaveTimeout);
        autoSaveTimeout = setTimeout(function() {
            updateMapAndCalculate();
        }, 500);
    });

    // Form change detection for unsaved changes warning
    let formChanged = false;
    $('form input, form select, form textarea').on('change', function() {
        formChanged = true;
    });

    // Warn before leaving if form changed
    $(window).on('beforeunload', function() {
        if (formChanged) {
            return 'Anda memiliki perubahan yang belum disimpan. Yakin ingin meninggalkan halaman?';
        }
    });

    // Don't warn when submitting form
    $('form').on('submit', function() {
        formChanged = false;
    });
});
</script>
<script>
// ============================================
// PART 16: EXPORT FUNCTIONS & CLEANUP
// ============================================

// Export all functions to window object for global access
window.initPengukuranMap = initPengukuranMap;
window.updateMapAndCalculate = updateMapAndCalculate;
window.addCoordinate = addCoordinate;
window.addCoordinateWithValues = addCoordinateWithValues;
window.removeCoordinate = removeCoordinate;
window.centerMap = centerMap;
window.captureMap = captureMap;
window.validateCoordinateInput = validateCoordinateInput;
window.nextTab = nextTab;
window.previousTab = previousTab;
window.saveDraft = saveDraft;

// RTRW Functions
window.loadRTRWData = loadRTRWData;
window.displayRTRWOverlay = displayRTRWOverlay;
window.checkPointInRTRW = checkPointInRTRW;
window.showRTRWPopup = showRTRWPopup;
window.checkAllCoordinatesRTRW = checkAllCoordinatesRTRW;
window.toggleRTRWOverlay = toggleRTRWOverlay;
window.updateRTRWSummary = updateRTRWSummary;
window.focusRTRW = focusRTRW;
// window.addRTRWToggleButton = addRTRWToggleButton;

// Cleanup function when leaving page
window.addEventListener('beforeunload', function() {
    // Clean up map resources
    if (pengukuranMap) {
        try {
            pengukuranMarkers.forEach(marker => {
                if (pengukuranMap.hasLayer(marker)) {
                    pengukuranMap.removeLayer(marker);
                }
            });

            rtrwLayers.forEach(layer => {
                if (pengukuranMap.hasLayer(layer)) {
                    pengukuranMap.removeLayer(layer);
                }
            });

            pengukuranMap.remove();
        } catch (e) {
            console.warn('Error during cleanup:', e);
        }
    }
});

// Auto-capture when coordinates change (debounced)
let captureTimeout;
let lastCaptureTime = 0;

function autoCapture() {
    const now = Date.now();

    // Prevent too frequent captures (min 2 seconds between captures)
    if (now - lastCaptureTime < 2000) {
        console.log('⏳ Skipping auto-capture (too soon)');
        return;
    }

    if (coordinates.length >= 3 && calculatedArea > 0) {
        if (captureTimeout) {
            clearTimeout(captureTimeout);
        }

        captureTimeout = setTimeout(function() {
            console.log('🎯 Triggering auto-capture...');
            const result = autoCaptureMap();
            if (result) {
                lastCaptureTime = Date.now();
            }
        }, 1000); // Reduced from 2000 to 1000ms for faster response
    }
}

// Expose autoCapture
window.autoCapture = autoCapture;

// Form validation sebelum submit
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const mapImageInput = document.getElementById('map_image_data');

            // Check if we have coordinates
            if (coordinates.length >= 3) {
                // Check if map_image_data is empty
                if (!mapImageInput || !mapImageInput.value || mapImageInput.value.trim() === '') {
                    e.preventDefault();

                    Swal.fire({
                        icon: 'warning',
                        title: 'Peta Belum Di-capture',
                        text: 'Sedang melakukan auto-capture peta...',
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    // Try to capture map
                    setTimeout(() => {
                        const captureResult = autoCaptureMap();

                        if (captureResult) {
                            Swal.close();
                            // Submit form after successful capture
                            form.submit();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Gagal Capture Peta',
                                text: 'Silakan klik tombol "Capture" secara manual terlebih dahulu',
                                confirmButtonColor: '#dc3545'
                            });
                        }
                    }, 1000);

                    return false;
                }
            }
        });
    }
});

console.log('✓ Edit pengukuran tab loaded successfully');
console.log('✓ Map functions initialized');
console.log('✓ RTRW integration enabled');
console.log('✓ Form validation enabled');
console.log('✓ All functions exported to window object');
</script>
@endpush
